/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit.io;

import com.webcodepro.shrinkit.io.BitConstants;
import java.io.IOException;
import java.io.InputStream;

public class BitInputStream
extends InputStream
implements BitConstants {
    private InputStream is;
    private int requestedNumberOfBits;
    private int bitMask;
    private int data = 0;
    private int bitsOfData = 0;

    public BitInputStream(InputStream is, int startingNumberOfBits) {
        this.is = is;
        this.setRequestedNumberOfBits(startingNumberOfBits);
    }

    public void setRequestedNumberOfBits(int numberOfBits) {
        this.requestedNumberOfBits = numberOfBits;
        this.bitMask = BIT_MASKS[numberOfBits];
    }

    public void increaseRequestedNumberOfBits() {
        this.setRequestedNumberOfBits(this.requestedNumberOfBits + 1);
    }

    public int getBitMask() {
        return this.bitMask;
    }

    @Override
    public int read() throws IOException {
        int b;
        while (this.bitsOfData < this.requestedNumberOfBits) {
            b = this.is.read();
            if (b == -1) {
                return b;
            }
            if (this.bitsOfData > 0) {
                b <<= this.bitsOfData;
            }
            this.data |= b;
            this.bitsOfData += 8;
        }
        b = this.data & this.bitMask;
        this.data >>= this.requestedNumberOfBits;
        this.bitsOfData -= this.requestedNumberOfBits;
        return b;
    }

    public void clearRemainingBitsOfData() {
        this.bitsOfData = 0;
        this.data = 0;
    }
}

